{smcl}
{* *! version 1.0.0  3feb2010}{...}
{cmd:help CI1D}{right:dialog:  {dialog CI1D}{space 1}}
{right:also see:  {help oneDproj}}
{hline}

{title:Title}

{p2colset 5 22 24 2}{...}
{p2col : CI1D {hline 2}} Implements estimation and inference of the one-dimensional identification regions of BLP coefficients from Beresteanu and 
Molinari (Econometrica, 2008) using the method described in Algorithm 4.2{p_end}
{p2colreset}{...}

{title:Syntax}

{p 8 18 2}
{cmd:CI1D}
	Ylow Yhigh XProj1 XProj2 ... XOther1 XOther2 ...
	[{cmd:,} {it:options} {cmd:nointercept reps(#) level(#) nocc nodu testnull(M) predict(M) contrast(M)}]

{synoptset 24 tabbed}{...}
{synopthdr}
{synoptline}

{synopt :{opt noint:ercept}} Suppress estimation and inference of the identification region for the intercept.  {p_end}
{synopt :{opt reps:}} Perform # bootstrap replications; default is reps(50). {p_end}
{synopt :{opt lev:el}} Set confidence level; default is level(.95). {p_end}
{synopt :{opt nocc:}} Suppress estimation of confidence collections based on the Hausdorff distance. {p_end}
{synopt :{opt nodu:}} Suppress estimation of confidence set based on the directed Hausdorff distance. {p_end}
{synopt :{opt pred:ict(M)}} Implements inference for the estimated identification region for the BLP with covariate values specified in matrix M. {p_end}
{synopt :{opt con:trast(M)}} Implements inference for the the estimated identification region for the contrast of BLPs with covariate values specified in matrix M. {p_end}
{synopt :{opt test:null(M)}} Implements hypothesis tests of inclusion/equality of test set M of BLP coefficient intervals with the estimated identification region 
	for the BLP coefficients.  {p_end}

{title:Description}

{pstd}
{cmd:CI1D} implements estimation and inference of the one-dimensional identification regions for specified components of the BLP coefficient vector as 
described in Beresteanu and Molinari (Econometrica, 2008).  Typing

{phang2}
{cmd:. CI1D} Ylow Yhigh XProj1 XProj2

{pstd}
executes the estimation procedure based on two X variables, displaying lower and upper bounds for the projections
of both X variables specified as XProj1 and XProj2. Note that the Ylow variable contains the lower bounds on the 
dependent variable and the Yhigh variable contains the upper bounds on the dependent variable.

{pstd}
This command also implements inference using nonparameteric bootstrap to obtain the following statistics:

{phang2}
(1) Critical values to use for inference regarding the identification region of each component of the BLP coefficient vector based 
	on the Hausdorff and directed Hausdorff distances.

{phang2}
(2) Confidence collections for the estimated identification region of each BLP coefficient based on the Hausdorff distance (CC).  The confidence collection
	is the collection of all sets that cannot be rejected by the equality test.

{phang2}
(3) Confidence sets for the estimated identification region of each BLP coefficient based on the directed Hausdorff distance (DU).  The confidence set, 
	the union of all sets that cannot be rejected by the inclusion test, represents the largest set that cannot be rejected by the inclusion test.

{phang2}
(4) Conclusion from hypothesis tests of the BLP coefficient set specified in the test option with the estimated identification region for the BLP 
	coefficents.

{phang2}
(5) (1) - (3) for BLP with covariate values specified in matrix M of the predict option.

{phang2}
(6) (1) - (3) for contrast of BLPs with covariate values specified in matrix M of the contrast option.

{pstd}
This command is an extension of {cmd:oneDproj}.  If you are only interested in estimation and not inference of the identification regions, then
use {cmd:oneDproj} since the bootstrap method in {cmd:CI1D} would require unnecessary computing time.

{title:Options}

{pstd}
Let p be the number of covariates in the model, including the intercept.

{pstd}
{cmd:predict} implements inference for the identification region for the BLP with the values of covariates specified in matrix M.
M must be specified as a Stata matrix, must be a p-1 x 1 matrix of covariate values, and must be ordered in the same manner 
as the covariates are listed in the original {cmd:CI1D} command.  Note that the intercept should not be specified by the user in matrix M.

{pstd}
{cmd:contrast} implements inference for the identification region for the difference between the BLPs at 
the values of covariates specified in the first column of matrix M and the values of covariates specified in the second 
column of matrix M.  M must be specified as a Stata matrix, must be a p-1 x 2 matrix of covariate values, and must be ordered in the same manner 
as the covariates are listed in the original {cmd:CI1D} command.  Note that the intercept should not be specified by the user in matrix M.

{pstd}
{cmd:testnull} implements hypothesis tests for inclusion/equality of the test set, specified in matrix M, with the estimated identification region for the 
BLP coefficients via the critical values based on the directed Hausdorff/Hausdorff distances.  M must be specified as a Stata matrix, must be a p x 2 matrix 
of BLP coefficient intervals to be tested, and must be ordered in the same manner 
as the covariates are listed in the original {cmd:CI1D} command.  The first column of M must contain the lower bound of the test region for each of the BLP 
coefficients, while the second column of matrix M must contain the upper bound of the test region for each of the BLP 
coefficients.  Note that the intercept test interval must be specified by the user in the first row of matrix M. 

{pstd} Note on {cmd:testnull}: it is not necessary to specify a test for all BLP coefficients, as these are not joint tests (each test is for a single BLP coefficient).  
Include a row of missing values, ".", in matrix M for those BLP coefficients that you are not interested in testing.

{title:Examples}

{pstd}Two Xs, only critical values requested{p_end}
{phang2}{cmd:. CI1D Ylow Yhigh X1 X2, nodu nocc}{p_end}

{pstd}One X, test of BLP coefficient for X1 requested with 100 replications{p_end}
{phang2}{cmd:. matrix M = [.,.\.5,1.5]}{p_end}
{phang2}{cmd:. CI1D Ylow Yhigh X1, test(M) reps(100)}{p_end}

{pstd}Two Xs, BLP inference requested at 90% confidence level{p_end}
{phang2}{cmd:. matrix M = [2.3\5.5]}{p_end}
{phang2}{cmd:. oneDproj Ylow Yhigh X1 X2, pred(M) lev(.90)}{p_end}

{title:Saved results}

{pstd}
{cmd:CI1D} saves the following in {cmd:e()}:

{synoptset 25 tabbed}{...}
{p2col 5 25 29 2: Matrices}{p_end}
{synopt:{cmd:e(Thetahat1D)}}Estimated identification regions for all BLP coefficients{p_end}
{synopt:{cmd:e(ThetahatPred)}}Estimated identification regions for BLP{p_end}
{synopt:{cmd:e(ThetahatPredCon)}}Estimated identification regions for contrast of BLPs{p_end}

{synopt:{cmd:e(cr_H)}}Critical values for BLP coefficients, based on Hausdorff distance{p_end}
{synopt:{cmd:e(cr_dH)}}Critical values for BLP coefficients, based on directed Hausdorff distance{p_end}
{synopt:{cmd:e(cr_H_pred)}}Critical value for BLP, based on Hausdorff distance{p_end}
{synopt:{cmd:e(cr_dH_pred)}}Critical value for BLP, based on directed Hausdorff distance{p_end}
{synopt:{cmd:e(cr_H_pred_con)}}Critical value for contrast of BLPs, based on Hausdorff distance{p_end}
{synopt:{cmd:e(cr_dH_pred_con)}}Critical value for contrast of BLPs, based on directed Hausdorff distance{p_end}

{synopt:{cmd:e(CC)}}Confidence collection for BLP coefficients, based on Hausdorff distance{p_end}
{synopt:{cmd:e(DU)}}Confidence set for BLP coefficients, based on directed Hausdorff distance{p_end}
{synopt:{cmd:e(CC_pred)}}Confidence collection for BLP, based on Hausdorff distance{p_end}
{synopt:{cmd:e(DU_pred)}}Confidence Set for BLP, based on directed Hausdorff distance{p_end}
{synopt:{cmd:e(CC_pred_con)}}Confidence collection for contrast of BLPs, based on Hausdorff distance{p_end}
{synopt:{cmd:e(DU_pred_con)}}Confidence set for contrast of BLPs, based on directed Hausdorff distance{p_end}

{p2colreset}{...}


{title:Also see}

{psee}
{space 2}Help: {help oneDproj}{break}
{p_end}
